<?php
# KONFIGUARTION EINBINDEN
include ("inc/konfiguration.php");

$f_da = null;

# GET
if ($_SERVER['REQUEST_METHOD'] == "GET" && isset($_GET["id"])) {

	$f_da = 1;
	$fid = sicher($_GET["id"]);
	
	$query = mysqli_query($con, "SELECT * FROM fahrzeuge WHERE fahrzeug_id = '".$fid."'") or die(mysqli_error($con));
	$fahrzeugdata = mysqli_fetch_array($query);
	
	if(mysqli_num_rows($query) == 0) {
		$f_da = 0;
		$zeige_fehlermeldung = zeige_fehler(4, "Fahrzeug wurde nicht gefunden");
	}
	else {
	
		#STECKBRIEF
		// Fahrzeugname
		$s_fahrzeugname = $fahrzeugdata['hersteller_name']." ".$fahrzeugdata['fahrzeug_name'];
		if(empty($s_fahrzeugname)) {
			$s_fahrzeugname = "k.A.";
		}
		// Motorart
		$s_motorart = $fahrzeugdata['fahrzeug_motor'];
		if(empty($s_motorart)) {
			$s_motorart = "k.A.";
		}
		// Höchstgeschwindigkeit
		$s_hoechstgeschwindigkeit = $fahrzeugdata['fahrzeug_max_kmh'];
		if(empty($s_hoechstgeschwindigkeit)) {
			$s_hoechstgeschwindigkeit = "k.A.";
		}
		else {
			$s_hoechstgeschwindigkeit = $s_hoechstgeschwindigkeit." km/h";
		}
		// Leistung
		$s_kw = $fahrzeugdata['fahrzeug_kw'];
		$s_ps = $fahrzeugdata['fahrzeug_ps'];
		if(empty($s_kw) AND empty($s_ps)) {
			$s_leistung = "k.A.";
		}
		else {
			$s_leistung = $s_kw." kW / ".$s_ps." PS";
		}
		// Hubraum
		$s_hubraum = $fahrzeugdata['fahrzeug_hubraum'];
		if(empty($s_hubraum)) {
			$s_hubraum = "k.A.";
		}
		else {
			$s_hubraum = $s_hubraum." ccm";
		}
		// Bildlink
		$bildlink = "img/pkwliste/hersteller/".$fahrzeugdata['hersteller_id'].".png";	
		# FAHRZEUG ID
		$fahrzeug_id = $fahrzeugdata['fahrzeug_id'];
		# FAHRZEUG NAME
		$fahrzeug_name = $fahrzeugdata['fahrzeug_name'];
		if(empty($fahrzeug_name)) {
			$fahrzeug_name = "k.A.";
		}
		# HSN
		$hsn = $fahrzeugdata['fahrzeug_hsn'];
		if(empty($hsn)) {
			$hsn = "k.A.";
		}
		# TSN
		$tsn = $fahrzeugdata['fahrzeug_tsn'];
		if(empty($tsn)) {
			$tsn = "k.A.";
		}
		# VSN
		$vsn = $fahrzeugdata['fahrzeug_vsn'];
		if(empty($vsn)) {
			$vsn = "k.A.";
		}
		# MARKE
		$marke = $fahrzeugdata['hersteller_name'];
		if(empty($marke)) {
			$tsn2 = "k.A.";
		}
		# MODELL
		$modell = $fahrzeugdata['modell_name'];
		if(empty($modell)) {
			$modell = "k.A.";
		}
		# TYP
		$typ = $fahrzeugdata['fahrzeug_typ'];
		if(empty($typ)) {
			$typ = "k.A.";
		}
		# EG NUMMER
		$eg_nummer = $fahrzeugdata['fahrzeug_eg_nummer'];
		if(empty($eg_nummer)) {
			$eg_nummer = "k.A.";
		}
		# MODELLSTART
		// Monat
		$start_monat = $fahrzeugdata['fahrzeug_prod_monat_von'];
		if($start_monat == null) {
			$start_monat = "01";
		}
		else {
			$start_monat = sprintf("%02d", $start_monat);
		}
		// Jahr
		$start_jahr = $fahrzeugdata['fahrzeug_prod_jahr_von'];
		if($start_jahr == null) {
			$start_jahr = "-";
		}	
		// Ausgabe
		$modellstart = $start_monat."/".$start_jahr;
		# MODELLENDE
		// Monat
		$ende_monat = $fahrzeugdata['fahrzeug_prod_monat_bis'];
		if($ende_monat == null) {
			$ende_monat = "12";
		}
		else {
			$ende_monat = sprintf("%02d", $ende_monat);
		}
		// Jahr
		$ende_jahr = $fahrzeugdata['fahrzeug_prod_jahr_bis'];
		if($ende_jahr == null) {
			$ende_jahr = "-";
		}	
		// Ausgabe
		$modellende = $ende_monat."/".$ende_jahr;	
		# MOTORART
		$motorart = $fahrzeugdata['fahrzeug_motor'];
		if(empty($motorart)) {
			$motorart = "k.A.";
		}
		# MOTORKENNBUCHSTABE
		$motorcode = $fahrzeugdata['fahrzeug_motorcode'];
		if(!empty($motorcode)) {
			$motorcode = $motorcode;
		}
		else {
			$motorcode = "k.A.";
		}
		# ÖLFÜLLMENGE
		$oelmenge = $fahrzeugdata['fahrzeug_motor_oelmenge'];
		if(!empty($oelmenge)) {
			$oelmenge = $oelmenge." l";
		}
		else {
			$oelmenge = "k.A.";
		}
		# KRAFTSTOFFART
		$kraftstoffart = $fahrzeugdata['fahrzeug_treibstoff'];
		if(empty($kraftstoffart)) {
			$kraftstoffart = "k.A.";
		}
		# HUBRAUM
		$hubraum = $fahrzeugdata['fahrzeug_hubraum'];
		if(empty($hubraum)) {
			$hubraum = "k.A.";
		}
		else {
			$hubraum = $hubraum." ccm";
		}
		# KW
		$kw = $fahrzeugdata['fahrzeug_kw'];
		if(empty($kw)) {
			$kw = "k.A.";
		}
		else {
			$kw = $kw." kW";
		}
		# PS
		$ps = $fahrzeugdata['fahrzeug_ps'];
		if(empty($ps)) {
			$ps = "k.A.";
		}
		else {
			$ps = $ps." PS";
		}
		# LEISTUNG BEI U/MIN
		$leistung_umin = $fahrzeugdata['fahrzeug_leistung_bei_umdrehungen'];
		if(empty($leistung_umin)) {
			$leistung_umin = "k.A.";
		}
		else {
			$leistung_umin = $leistung_umin." U/min";
		}
		# ANTRIEBSART
		$antriebsart = $fahrzeugdata['fahrzeug_antriebsachse'];
		if(empty($antriebsart)) {
			$antriebsart = "k.A.";
		}
		# LÄNGE
		$laenge = $fahrzeugdata['fahrzeug_laenge'];
		if(empty($laenge)) {
			$laenge = "k.A.";
		}
		else {
			$laenge = $laenge." mm";
		}
		# BREITE
		$breite = $fahrzeugdata['fahrzeug_breite'];
		if(empty($breite)) {
			$breite = "k.A.";
		}
		else {
			$breite = $breite." mm";
		}
		# HÖHE
		$hoehe = $fahrzeugdata['fahrzeug_hoehe'];
		if(empty($hoehe)) {
			$hoehe = "k.A.";
		}
		else {
			$hoehe = $hoehe." mm";
		}
		# LEERGEWICHT
		$leergewicht = $fahrzeugdata['fahrzeug_leergewicht'];
		if(empty($leergewicht)) {
			$leergewicht = "k.A.";
		}
		else {
			$leergewicht = $leergewicht." kg";
		}
		# ZUL. GESAMTGEWICHT
		$zul_gesamtgewicht = $fahrzeugdata['fahrzeug_zul_gesamtgewicht'];
		if(empty($zul_gesamtgewicht)) {
			$zul_gesamtgewicht = "k.A.";
		}
		else {
			$zul_gesamtgewicht = $zul_gesamtgewicht." kg";
		}
		# STÜTZLAST
		$stuetzlast = $fahrzeugdata['fahrzeug_stuetzlast'];
		if(empty($stuetzlast)) {
			$stuetzlast = "k.A.";
		}
		else {
			$stuetzlast = $stuetzlast." kg";
		}
		# ANHÄNGELAST (gebremst)
		$anhaengelast_gebremst = $fahrzeugdata['fahrzeug_anhaengelast_gebremst'];
		if(empty($anhaengelast_gebremst)) {
			$anhaengelast_gebremst = "k.A.";
		}
		else {
			$anhaengelast_gebremst = $anhaengelast_gebremst." kg";
		}
		# ANHÄNGELAST (ungebremst)
		$anhaengelast_ungebremst = $fahrzeugdata['fahrzeug_anhaengelast_ungebremst'];
		if(empty($anhaengelast_ungebremst)) {
			$anhaengelast_ungebremst = "k.A.";
		}
		else {
			$anhaengelast_ungebremst = $anhaengelast_ungebremst." kg";
		}
		# KAROSSERIE
		$karosserie = $fahrzeugdata['fahrzeug_form'];
		if(empty($karosserie)) {
			$karosserie = "k.A.";
		}
		# HÖCHSTGESCHWINDIGKEIT
		$hoechstgeschwindigkeit = $fahrzeugdata['fahrzeug_max_kmh'];
		if(empty($hoechstgeschwindigkeit)) {
			$hoechstgeschwindigkeit = "k.A.";
		}
		else {
			$hoechstgeschwindigkeit = $hoechstgeschwindigkeit." km/h";
		}
		# SITZANZAHL
		$sitzanzahl = $fahrzeugdata['fahrzeug_sitzanzahl'];
		if(empty($sitzanzahl)) {
			$sitzanzahl = "k.A.";
		}
		# TÜRANZAHL
		$tueranzahl = $fahrzeugdata['fahrzeug_tueranzahl'];
		if(empty($tueranzahl)) {
			$tueranzahl = "k.A.";
		}
		# ACHSLAST VA
		$achslast_va = $fahrzeugdata['fahrzeug_achslast_va'];
		if(empty($achslast_va)) {
			$achslast_va = "k.A.";
		}
		else {
			$achslast_va = $achslast_va." kg";
		}
		# ACHSLAST HA
		$achslast_ha = $fahrzeugdata['fahrzeug_achslast_ha'];
		if(empty($achslast_ha)) {
			$achslast_ha = "k.A.";
		}
		else {
			$achslast_ha = $achslast_ha." kg";
		}
		# CO2 WERT
		$co2_emission = $fahrzeugdata['fahrzeug_co2_emissions_wert'];
		if(empty($co2_emission)) {
			$co2_emission = "k.A.";
		}
		else {
			$co2_emission = $co2_emission." g/km";
		}
	
	}
	
}
else {
	
	$zeige_fehlermeldung = zeige_fehler(4, "Kein Fahrzeug ausgewählt");

}
?>
<!DOCTYPE html>
<html lang="de">
	<head>
		<!-- Meta -->
		<meta charset="utf-8" />
		<meta name="viewport" content="width=device-width, initial-scale=1" />
		<!-- CSS -->
		<link rel="stylesheet" href="css/default.css" />
		<!-- Title -->
		<title>Demo - Fahrzeuginformation | pkwliste.com</title>
		<!-- Favicons -->
		<link rel="apple-touch-icon" sizes="180x180" href="img/favicon/apple-touch-icon.png" />
		<link rel="icon" type="image/png" sizes="32x32" href="img/favicon/favicon-32x32.png" />
		<link rel="icon" type="image/png" sizes="16x16" href="img/favicon/favicon-16x16.png" />
		<link rel="shortcut icon" href="img/favicon/favicon.ico" />
	</head>
	<body>
		<div class="main-content">
			<header class="main-header">
				<div class="container">
					<div class="header-container">
						<div class="header-logo">
							<a title="pkwliste.com" href="index.php">
								<img alt="PKW Liste" title="PKW Liste" class="img-responsive" src="img/logo/logo.png" />
							</a>
						</div>
						<div class="link-list hidden-sm hidden-xs">
							<div class="links">
								<a class="link" title="Zurück" href="index.php">
									Zurück
								</a>
							</div>
						</div>
					</div>
				</div>
			</header>
			<div class="container">
				<div class="top-titel-bar">
					<div class="row">
						<div class="col-xs-12">
							<span>Fahrzeuginformation</span>
						</div>
					</div>
				</div>
				<div class="bottom-titel-bar">
					<div class="row">
						<div class="col-xs-12">
							<p>
								Ihre Fahrzeugauswahl: 
							</p>
						</div>
					</div>
				</div>
				<?php echo $zeige_fehlermeldung; ?>
				<div class="fahrzeuginformation">
					<?php if($f_da == 1) { ?><div class="row equal">
						<div class="col-md-12">
							<h1><?php echo $s_fahrzeugname; ?></h1>
							<hr class="hr1" />
							
							 <div class="row">
								<div class="col-sm-2">
									<div class="panel panel-default">
										<div class="panel-body panel-logo">
											<img src="<?php echo $bildlink; ?>" />
										</div>
									</div>
								</div>
								<div class="col-sm-10">
									<div class="row">
										<div class="col-sm-6">
											<div class="panel panel-default">
												<div class="panel-body">
													<i class="motorart"></i>
													<h6><?php echo $s_motorart; ?></h6>
													<p>Motorart</p>
												</div>
											</div>
										</div>
										<div class="col-sm-6">
											<div class="panel panel-default">
												<div class="panel-body">
													<i class="geschwindigkeit"></i>
													<h6><?php echo $s_hoechstgeschwindigkeit; ?></h6>
													<p>Höchstgeschwindigkeit</p>
												</div>
											</div>
										</div>
										<div class="col-sm-6">
											<div class="panel panel-default">
												<div class="panel-body">
													<i class="leistung"></i>
													<h6><?php echo $s_leistung; ?></h6>
													<p>Leistung</p>
												</div>
											</div>
										</div>
										<div class="col-sm-6">
											<div class="panel panel-default">
												<div class="panel-body">
													<i class="hubraum"></i>
													<h6><?php echo $s_hubraum; ?></h6>
													<p>Hubraum</p>
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
					<hr class="hr2" />
					<div class="row">
						<div class="col-xs-12">
							<h2>Allgemeines</h2>
							<table class="table table-striped table-hover">
								<tbody>
									<tr>
										<td width="30%">Fahrzeug ID</td>
										<td width="70%"><?php echo $fahrzeug_id; ?></td>
									</tr>
									<tr>
										<td>Fahrzeug Name</td>
										<td><?php echo $fahrzeug_name; ?></td>
									</tr>
									<tr>
										<td>HSN</td>
										<td><?php echo $hsn; ?></td>
									</tr>
									<tr>
										<td>TSN</td>
										<td><?php echo $tsn; ?></td>
									</tr>
									<tr>
										<td>VSN</td>
										<td><?php echo $vsn; ?></td>
									</tr>
									<tr>
										<td>Marke</td>
										<td><?php echo $marke; ?></td>
									</tr>
									<tr>
										<td>Modell</td>
										<td><?php echo $modell; ?></td>
									</tr>
									<tr>
										<td>Typ</td>
										<td><?php echo $typ; ?></td>
									</tr>
									<tr>
										<td>EG Nummer</td>
										<td><?php echo $eg_nummer; ?></td>
									</tr>
									<tr>
										<td>Modellstart</td>
										<td><?php echo $modellstart; ?></td>
									</tr>
									<tr>
										<td>Modellende</td>
										<td><?php echo $modellende; ?></td>
									</tr>
								</tbody>
							</table>
							<hr class="hr3" />
							<h2>Motor und Antrieb</h2>
							<table class="table table-striped table-hover">
								<tbody>
									<tr>
										<td width="30%">Motorart</td>
										<td width="70%"><?php echo $motorart; ?></td>
									</tr>
									<tr>
										<td>Motorkennbuchstabe(n)</td>
										<td><?php echo $motorcode; ?></td>
									</tr>
									<tr>
										<td>Motoröl-Füllmenge inkl. Filter (Servicebefüllung)</td>
										<td><?php echo $oelmenge ; ?></td>
									</tr>
									<tr>
										<td>Kraftstoffart</td>
										<td><?php echo $kraftstoffart; ?></td>
									</tr>
									<tr>
										<td>Hubraum</td>
										<td><?php echo $hubraum; ?></td>
									</tr>
									<tr>
										<td>KW</td>
										<td><?php echo $kw; ?></td>
									</tr>
									<tr>
										<td>PS</td>
										<td><?php echo $ps; ?></td>
									</tr>
									<tr>
										<td>Leistung bei U/min</td>
										<td><?php echo $leistung_umin; ?></td>
									</tr>
									<tr>
										<td>Antriebsart</td>
										<td><?php echo $antriebsart; ?></td>
									</tr>
								</tbody>
							</table>
							<hr class="hr3" />
							<h2>Maße und Gewichte</h2>
							<table class="table table-striped table-hover">
								<tbody>
									<tr>
										<td width="30%">Länge</td>
										<td width="70%"><?php echo $laenge; ?></td>
									</tr>
									<tr>
										<td width="30%">Breite</td>
										<td width="70%"><?php echo $breite; ?></td>
									</tr>
									<tr>
										<td width="30%">Höhe</td>
										<td width="70%"><?php echo $hoehe; ?></td>
									</tr>
									<tr>
										<td width="30%">Leergewicht</td>
										<td width="70%"><?php echo $leergewicht; ?></td>
									</tr>
									<tr>
										<td width="30%">Zul. Gesamtgewicht</td>
										<td width="70%"><?php echo $zul_gesamtgewicht; ?></td>
									</tr>
									<tr>
										<td width="30%">Stützlast</td>
										<td width="70%"><?php echo $stuetzlast; ?></td>
									</tr>
									<tr>
										<td width="30%">Anhängelast (gebremst)</td>
										<td width="70%"><?php echo $anhaengelast_gebremst; ?></td>
									</tr>
									<tr>
										<td width="30%">Anhängelast (ungebremst)</td>
										<td width="70%"><?php echo $anhaengelast_ungebremst; ?></td>
									</tr>
									<tr>
										<td width="30%">Achslast VA</td>
										<td width="70%"><?php echo $achslast_va; ?></td>
									</tr>
									<tr>
										<td width="30%">Achslast HA</td>
										<td width="70%"><?php echo $achslast_ha; ?></td>
									</tr>
								</tbody>
							</table>
							<hr class="hr3" />
							<h2>Karosserie und Fahrwerk</h2>
							<table class="table table-striped table-hover">
								<tbody>
									<tr>
										<td width="30%">Karosserie</td>
										<td width="70%"><?php echo $karosserie; ?></td>
									</tr>
									<tr>
										<td width="30%">Sitzanzahl</td>
										<td width="70%"><?php echo $sitzanzahl; ?></td>
									</tr>
									<tr>
										<td width="30%">Türanzahl</td>
										<td width="70%"><?php echo $tueranzahl; ?></td>
									</tr>
								</tbody>
							</table>
							<hr class="hr3" />
							<h2>Messwerte</h2>
							<table class="table table-striped table-hover">
								<tbody>
									<tr>
										<td width="30%">Höchstgeschwindigkeit</td>
										<td width="70%"><?php echo $hoechstgeschwindigkeit; ?></td>
									</tr>
									<tr>
										<td width="30%">CO2 Wert</td>
										<td width="70%"><?php echo $co2_emission; ?></td>
									</tr>
								</tbody>
							</table>
						</div>
					</div><?php } ?>
				</div>			
			</div>
			<div class="container">
				<hr class="banner-horizontal-line">
				<div class="row">
					<div class="col-md-12 col-xs-12">
						<p>
							&copy; <?php echo date("Y"); ?> pkwliste.com
						</p>
					</div>
				</div>
			</div>
		</div>		
		<script src="js/default.js"></script>
	</body>
</html>